package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class ChangeResourceRecordSetsRequest(
    hostedZoneId: ResourceId,
    changeBatch: zio.aws.route53.model.ChangeBatch
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest = {
    import ChangeResourceRecordSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .changeBatch(changeBatch.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ChangeResourceRecordSetsRequest.ReadOnly =
    zio.aws.route53.model.ChangeResourceRecordSetsRequest.wrap(buildAwsValue())
}
object ChangeResourceRecordSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ChangeResourceRecordSetsRequest =
      zio.aws.route53.model
        .ChangeResourceRecordSetsRequest(hostedZoneId, changeBatch.asEditable)
    def hostedZoneId: ResourceId
    def changeBatch: zio.aws.route53.model.ChangeBatch.ReadOnly
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getChangeBatch
        : ZIO[Any, Nothing, zio.aws.route53.model.ChangeBatch.ReadOnly] =
      ZIO.succeed(changeBatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest
  ) extends zio.aws.route53.model.ChangeResourceRecordSetsRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val changeBatch: zio.aws.route53.model.ChangeBatch.ReadOnly =
      zio.aws.route53.model.ChangeBatch.wrap(impl.changeBatch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest
  ): zio.aws.route53.model.ChangeResourceRecordSetsRequest.ReadOnly =
    new Wrapper(impl)
}
