package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait ChangeStatus {
  def unwrap: software.amazon.awssdk.services.route53.model.ChangeStatus
}
object ChangeStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.ChangeStatus
  ): zio.aws.route53.model.ChangeStatus = value match {
    case software.amazon.awssdk.services.route53.model.ChangeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.ChangeStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.route53.model.ChangeStatus.INSYNC =>
      val r = INSYNC
      r
  }
  case object unknownToSdkVersion extends zio.aws.route53.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ChangeStatus =
      software.amazon.awssdk.services.route53.model.ChangeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.route53.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ChangeStatus =
      software.amazon.awssdk.services.route53.model.ChangeStatus.PENDING
  }
  case object INSYNC extends zio.aws.route53.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ChangeStatus =
      software.amazon.awssdk.services.route53.model.ChangeStatus.INSYNC
  }
}
