package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{TagKey, TagResourceId}
import scala.jdk.CollectionConverters._
final case class ChangeTagsForResourceRequest(
    resourceType: zio.aws.route53.model.TagResourceType,
    resourceId: TagResourceId,
    addTags: Optional[Iterable[zio.aws.route53.model.Tag]] = Optional.Absent,
    removeTagKeys: Optional[Iterable[TagKey]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest = {
    import ChangeTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceId(TagResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        addTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addTags)
      .optionallyWith(
        removeTagKeys.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeTagKeys)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ChangeTagsForResourceRequest.ReadOnly =
    zio.aws.route53.model.ChangeTagsForResourceRequest.wrap(buildAwsValue())
}
object ChangeTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ChangeTagsForResourceRequest =
      zio.aws.route53.model.ChangeTagsForResourceRequest(
        resourceType,
        resourceId,
        addTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeTagKeys.map(value => value)
      )
    def resourceType: zio.aws.route53.model.TagResourceType
    def resourceId: TagResourceId
    def addTags: Optional[List[zio.aws.route53.model.Tag.ReadOnly]]
    def removeTagKeys: Optional[List[TagKey]]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.route53.model.TagResourceType] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, TagResourceId] =
      ZIO.succeed(resourceId)
    def getAddTags
        : ZIO[Any, AwsError, List[zio.aws.route53.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("addTags", addTags)
    def getRemoveTagKeys: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("removeTagKeys", removeTagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest
  ) extends zio.aws.route53.model.ChangeTagsForResourceRequest.ReadOnly {
    override val resourceType: zio.aws.route53.model.TagResourceType =
      zio.aws.route53.model.TagResourceType.wrap(impl.resourceType())
    override val resourceId: TagResourceId =
      zio.aws.route53.model.primitives.TagResourceId(impl.resourceId())
    override val addTags: Optional[List[zio.aws.route53.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.Tag.wrap(item)
          }.toList
        )
    override val removeTagKeys: Optional[List[TagKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.removeTagKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53.model.primitives.TagKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest
  ): zio.aws.route53.model.ChangeTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
