package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  CidrLocationNameDefaultNotAllowed,
  Cidr
}
import scala.jdk.CollectionConverters._
final case class CidrBlockSummary(
    cidrBlock: Optional[Cidr] = Optional.Absent,
    locationName: Optional[CidrLocationNameDefaultNotAllowed] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CidrBlockSummary = {
    import CidrBlockSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CidrBlockSummary
      .builder()
      .optionallyWith(
        cidrBlock.map(value => Cidr.unwrap(value): java.lang.String)
      )(_.cidrBlock)
      .optionallyWith(
        locationName.map(value =>
          CidrLocationNameDefaultNotAllowed.unwrap(value): java.lang.String
        )
      )(_.locationName)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CidrBlockSummary.ReadOnly =
    zio.aws.route53.model.CidrBlockSummary.wrap(buildAwsValue())
}
object CidrBlockSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CidrBlockSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CidrBlockSummary =
      zio.aws.route53.model.CidrBlockSummary(
        cidrBlock.map(value => value),
        locationName.map(value => value)
      )
    def cidrBlock: Optional[Cidr]
    def locationName: Optional[CidrLocationNameDefaultNotAllowed]
    def getCidrBlock: ZIO[Any, AwsError, Cidr] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getLocationName: ZIO[Any, AwsError, CidrLocationNameDefaultNotAllowed] =
      AwsError.unwrapOptionField("locationName", locationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CidrBlockSummary
  ) extends zio.aws.route53.model.CidrBlockSummary.ReadOnly {
    override val cidrBlock: Optional[Cidr] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => zio.aws.route53.model.primitives.Cidr(value))
    override val locationName: Optional[CidrLocationNameDefaultNotAllowed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationName())
        .map(value =>
          zio.aws.route53.model.primitives
            .CidrLocationNameDefaultNotAllowed(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CidrBlockSummary
  ): zio.aws.route53.model.CidrBlockSummary.ReadOnly = new Wrapper(impl)
}
