package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  Cidr,
  CidrLocationNameDefaultNotAllowed
}
import scala.jdk.CollectionConverters._
final case class CidrCollectionChange(
    locationName: CidrLocationNameDefaultNotAllowed,
    action: zio.aws.route53.model.CidrCollectionChangeAction,
    cidrList: Iterable[Cidr]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CidrCollectionChange = {
    import CidrCollectionChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CidrCollectionChange
      .builder()
      .locationName(
        CidrLocationNameDefaultNotAllowed.unwrap(locationName): java.lang.String
      )
      .action(action.unwrap)
      .cidrList(cidrList.map { item =>
        Cidr.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CidrCollectionChange.ReadOnly =
    zio.aws.route53.model.CidrCollectionChange.wrap(buildAwsValue())
}
object CidrCollectionChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CidrCollectionChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CidrCollectionChange =
      zio.aws.route53.model.CidrCollectionChange(locationName, action, cidrList)
    def locationName: CidrLocationNameDefaultNotAllowed
    def action: zio.aws.route53.model.CidrCollectionChangeAction
    def cidrList: List[Cidr]
    def getLocationName: ZIO[Any, Nothing, CidrLocationNameDefaultNotAllowed] =
      ZIO.succeed(locationName)
    def getAction
        : ZIO[Any, Nothing, zio.aws.route53.model.CidrCollectionChangeAction] =
      ZIO.succeed(action)
    def getCidrList: ZIO[Any, Nothing, List[Cidr]] = ZIO.succeed(cidrList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CidrCollectionChange
  ) extends zio.aws.route53.model.CidrCollectionChange.ReadOnly {
    override val locationName: CidrLocationNameDefaultNotAllowed =
      zio.aws.route53.model.primitives
        .CidrLocationNameDefaultNotAllowed(impl.locationName())
    override val action: zio.aws.route53.model.CidrCollectionChangeAction =
      zio.aws.route53.model.CidrCollectionChangeAction.wrap(impl.action())
    override val cidrList: List[Cidr] = impl
      .cidrList()
      .asScala
      .map { item =>
        zio.aws.route53.model.primitives.Cidr(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CidrCollectionChange
  ): zio.aws.route53.model.CidrCollectionChange.ReadOnly = new Wrapper(impl)
}
