package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait CidrCollectionChangeAction {
  def unwrap
      : software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction
}
object CidrCollectionChangeAction {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction
  ): zio.aws.route53.model.CidrCollectionChangeAction = value match {
    case software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction.PUT =>
      val r = PUT
      r
    case software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction.DELETE_IF_EXISTS =>
      val r = DELETE_IF_EXISTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.CidrCollectionChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction =
      software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object PUT extends zio.aws.route53.model.CidrCollectionChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction =
      software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction.PUT
  }
  case object DELETE_IF_EXISTS
      extends zio.aws.route53.model.CidrCollectionChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction =
      software.amazon.awssdk.services.route53.model.CidrCollectionChangeAction.DELETE_IF_EXISTS
  }
}
