package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{CidrLocationNameDefaultAllowed, UUID}
import scala.jdk.CollectionConverters._
final case class CidrRoutingConfig(
    collectionId: UUID,
    locationName: CidrLocationNameDefaultAllowed
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CidrRoutingConfig = {
    import CidrRoutingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CidrRoutingConfig
      .builder()
      .collectionId(UUID.unwrap(collectionId): java.lang.String)
      .locationName(
        CidrLocationNameDefaultAllowed.unwrap(locationName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CidrRoutingConfig.ReadOnly =
    zio.aws.route53.model.CidrRoutingConfig.wrap(buildAwsValue())
}
object CidrRoutingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CidrRoutingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CidrRoutingConfig =
      zio.aws.route53.model.CidrRoutingConfig(collectionId, locationName)
    def collectionId: UUID
    def locationName: CidrLocationNameDefaultAllowed
    def getCollectionId: ZIO[Any, Nothing, UUID] = ZIO.succeed(collectionId)
    def getLocationName: ZIO[Any, Nothing, CidrLocationNameDefaultAllowed] =
      ZIO.succeed(locationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CidrRoutingConfig
  ) extends zio.aws.route53.model.CidrRoutingConfig.ReadOnly {
    override val collectionId: UUID =
      zio.aws.route53.model.primitives.UUID(impl.collectionId())
    override val locationName: CidrLocationNameDefaultAllowed =
      zio.aws.route53.model.primitives
        .CidrLocationNameDefaultAllowed(impl.locationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CidrRoutingConfig
  ): zio.aws.route53.model.CidrRoutingConfig.ReadOnly = new Wrapper(impl)
}
