package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  CollectionVersion,
  CollectionName,
  UUID,
  ARN
}
import scala.jdk.CollectionConverters._
final case class CollectionSummary(
    arn: Optional[ARN] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    name: Optional[CollectionName] = Optional.Absent,
    version: Optional[CollectionVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CollectionSummary = {
    import CollectionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CollectionSummary
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => CollectionName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => CollectionVersion.unwrap(value): java.lang.Long)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CollectionSummary.ReadOnly =
    zio.aws.route53.model.CollectionSummary.wrap(buildAwsValue())
}
object CollectionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CollectionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CollectionSummary =
      zio.aws.route53.model.CollectionSummary(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        version.map(value => value)
      )
    def arn: Optional[ARN]
    def id: Optional[UUID]
    def name: Optional[CollectionName]
    def version: Optional[CollectionVersion]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, CollectionVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CollectionSummary
  ) extends zio.aws.route53.model.CollectionSummary.ReadOnly {
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53.model.primitives.ARN(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53.model.primitives.UUID(value))
    override val name: Optional[CollectionName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53.model.primitives.CollectionName(value))
    override val version: Optional[CollectionVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.route53.model.primitives.CollectionVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CollectionSummary
  ): zio.aws.route53.model.CollectionSummary.ReadOnly = new Wrapper(impl)
}
