package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{Longitude, Latitude}
import scala.jdk.CollectionConverters._
final case class Coordinates(latitude: Latitude, longitude: Longitude) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.Coordinates = {
    import Coordinates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.Coordinates
      .builder()
      .latitude(Latitude.unwrap(latitude): java.lang.String)
      .longitude(Longitude.unwrap(longitude): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.Coordinates.ReadOnly =
    zio.aws.route53.model.Coordinates.wrap(buildAwsValue())
}
object Coordinates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.Coordinates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.Coordinates =
      zio.aws.route53.model.Coordinates(latitude, longitude)
    def latitude: Latitude
    def longitude: Longitude
    def getLatitude: ZIO[Any, Nothing, Latitude] = ZIO.succeed(latitude)
    def getLongitude: ZIO[Any, Nothing, Longitude] = ZIO.succeed(longitude)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.Coordinates
  ) extends zio.aws.route53.model.Coordinates.ReadOnly {
    override val latitude: Latitude =
      zio.aws.route53.model.primitives.Latitude(impl.latitude())
    override val longitude: Longitude =
      zio.aws.route53.model.primitives.Longitude(impl.longitude())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.Coordinates
  ): zio.aws.route53.model.Coordinates.ReadOnly = new Wrapper(impl)
}
