package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{CidrNonce, CollectionName}
import scala.jdk.CollectionConverters._
final case class CreateCidrCollectionRequest(
    name: CollectionName,
    callerReference: CidrNonce
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest = {
    import CreateCidrCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest
      .builder()
      .name(CollectionName.unwrap(name): java.lang.String)
      .callerReference(CidrNonce.unwrap(callerReference): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateCidrCollectionRequest.ReadOnly =
    zio.aws.route53.model.CreateCidrCollectionRequest.wrap(buildAwsValue())
}
object CreateCidrCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateCidrCollectionRequest =
      zio.aws.route53.model.CreateCidrCollectionRequest(name, callerReference)
    def name: CollectionName
    def callerReference: CidrNonce
    def getName: ZIO[Any, Nothing, CollectionName] = ZIO.succeed(name)
    def getCallerReference: ZIO[Any, Nothing, CidrNonce] =
      ZIO.succeed(callerReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest
  ) extends zio.aws.route53.model.CreateCidrCollectionRequest.ReadOnly {
    override val name: CollectionName =
      zio.aws.route53.model.primitives.CollectionName(impl.name())
    override val callerReference: CidrNonce =
      zio.aws.route53.model.primitives.CidrNonce(impl.callerReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateCidrCollectionRequest
  ): zio.aws.route53.model.CreateCidrCollectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
