package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters._
final case class CreateCidrCollectionResponse(
    collection: Optional[zio.aws.route53.model.CidrCollection] =
      Optional.Absent,
    location: Optional[ResourceURI] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateCidrCollectionResponse = {
    import CreateCidrCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateCidrCollectionResponse
      .builder()
      .optionallyWith(collection.map(value => value.buildAwsValue()))(
        _.collection
      )
      .optionallyWith(
        location.map(value => ResourceURI.unwrap(value): java.lang.String)
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateCidrCollectionResponse.ReadOnly =
    zio.aws.route53.model.CreateCidrCollectionResponse.wrap(buildAwsValue())
}
object CreateCidrCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateCidrCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateCidrCollectionResponse =
      zio.aws.route53.model.CreateCidrCollectionResponse(
        collection.map(value => value.asEditable),
        location.map(value => value)
      )
    def collection: Optional[zio.aws.route53.model.CidrCollection.ReadOnly]
    def location: Optional[ResourceURI]
    def getCollection
        : ZIO[Any, AwsError, zio.aws.route53.model.CidrCollection.ReadOnly] =
      AwsError.unwrapOptionField("collection", collection)
    def getLocation: ZIO[Any, AwsError, ResourceURI] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateCidrCollectionResponse
  ) extends zio.aws.route53.model.CreateCidrCollectionResponse.ReadOnly {
    override val collection
        : Optional[zio.aws.route53.model.CidrCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collection())
        .map(value => zio.aws.route53.model.CidrCollection.wrap(value))
    override val location: Optional[ResourceURI] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.route53.model.primitives.ResourceURI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateCidrCollectionResponse
  ): zio.aws.route53.model.CreateCidrCollectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
