package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters._
final case class CreateHealthCheckResponse(
    healthCheck: zio.aws.route53.model.HealthCheck,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse = {
    import CreateHealthCheckResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse
      .builder()
      .healthCheck(healthCheck.buildAwsValue())
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly =
    zio.aws.route53.model.CreateHealthCheckResponse.wrap(buildAwsValue())
}
object CreateHealthCheckResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateHealthCheckResponse =
      zio.aws.route53.model
        .CreateHealthCheckResponse(healthCheck.asEditable, location)
    def healthCheck: zio.aws.route53.model.HealthCheck.ReadOnly
    def location: ResourceURI
    def getHealthCheck
        : ZIO[Any, Nothing, zio.aws.route53.model.HealthCheck.ReadOnly] =
      ZIO.succeed(healthCheck)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse
  ) extends zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly {
    override val healthCheck: zio.aws.route53.model.HealthCheck.ReadOnly =
      zio.aws.route53.model.HealthCheck.wrap(impl.healthCheck())
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse
  ): zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly = new Wrapper(
    impl
  )
}
