package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters._
final case class CreateHostedZoneResponse(
    hostedZone: zio.aws.route53.model.HostedZone,
    changeInfo: zio.aws.route53.model.ChangeInfo,
    delegationSet: zio.aws.route53.model.DelegationSet,
    vpc: Optional[zio.aws.route53.model.VPC] = Optional.Absent,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse = {
    import CreateHostedZoneResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse
      .builder()
      .hostedZone(hostedZone.buildAwsValue())
      .changeInfo(changeInfo.buildAwsValue())
      .delegationSet(delegationSet.buildAwsValue())
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly =
    zio.aws.route53.model.CreateHostedZoneResponse.wrap(buildAwsValue())
}
object CreateHostedZoneResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateHostedZoneResponse =
      zio.aws.route53.model.CreateHostedZoneResponse(
        hostedZone.asEditable,
        changeInfo.asEditable,
        delegationSet.asEditable,
        vpc.map(value => value.asEditable),
        location
      )
    def hostedZone: zio.aws.route53.model.HostedZone.ReadOnly
    def changeInfo: zio.aws.route53.model.ChangeInfo.ReadOnly
    def delegationSet: zio.aws.route53.model.DelegationSet.ReadOnly
    def vpc: Optional[zio.aws.route53.model.VPC.ReadOnly]
    def location: ResourceURI
    def getHostedZone
        : ZIO[Any, Nothing, zio.aws.route53.model.HostedZone.ReadOnly] =
      ZIO.succeed(hostedZone)
    def getChangeInfo
        : ZIO[Any, Nothing, zio.aws.route53.model.ChangeInfo.ReadOnly] =
      ZIO.succeed(changeInfo)
    def getDelegationSet
        : ZIO[Any, Nothing, zio.aws.route53.model.DelegationSet.ReadOnly] =
      ZIO.succeed(delegationSet)
    def getVpc: ZIO[Any, AwsError, zio.aws.route53.model.VPC.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse
  ) extends zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly {
    override val hostedZone: zio.aws.route53.model.HostedZone.ReadOnly =
      zio.aws.route53.model.HostedZone.wrap(impl.hostedZone())
    override val changeInfo: zio.aws.route53.model.ChangeInfo.ReadOnly =
      zio.aws.route53.model.ChangeInfo.wrap(impl.changeInfo())
    override val delegationSet: zio.aws.route53.model.DelegationSet.ReadOnly =
      zio.aws.route53.model.DelegationSet.wrap(impl.delegationSet())
    override val vpc: Optional[zio.aws.route53.model.VPC.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpc())
        .map(value => zio.aws.route53.model.VPC.wrap(value))
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse
  ): zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly = new Wrapper(impl)
}
