package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  Nonce,
  SigningKeyString,
  SigningKeyName,
  SigningKeyStatus,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class CreateKeySigningKeyRequest(
    callerReference: Nonce,
    hostedZoneId: ResourceId,
    keyManagementServiceArn: SigningKeyString,
    name: SigningKeyName,
    status: SigningKeyStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest = {
    import CreateKeySigningKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest
      .builder()
      .callerReference(Nonce.unwrap(callerReference): java.lang.String)
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .keyManagementServiceArn(
        SigningKeyString.unwrap(keyManagementServiceArn): java.lang.String
      )
      .name(SigningKeyName.unwrap(name): java.lang.String)
      .status(SigningKeyStatus.unwrap(status): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateKeySigningKeyRequest.ReadOnly =
    zio.aws.route53.model.CreateKeySigningKeyRequest.wrap(buildAwsValue())
}
object CreateKeySigningKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateKeySigningKeyRequest =
      zio.aws.route53.model.CreateKeySigningKeyRequest(
        callerReference,
        hostedZoneId,
        keyManagementServiceArn,
        name,
        status
      )
    def callerReference: Nonce
    def hostedZoneId: ResourceId
    def keyManagementServiceArn: SigningKeyString
    def name: SigningKeyName
    def status: SigningKeyStatus
    def getCallerReference: ZIO[Any, Nothing, Nonce] =
      ZIO.succeed(callerReference)
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getKeyManagementServiceArn: ZIO[Any, Nothing, SigningKeyString] =
      ZIO.succeed(keyManagementServiceArn)
    def getName: ZIO[Any, Nothing, SigningKeyName] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, SigningKeyStatus] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest
  ) extends zio.aws.route53.model.CreateKeySigningKeyRequest.ReadOnly {
    override val callerReference: Nonce =
      zio.aws.route53.model.primitives.Nonce(impl.callerReference())
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val keyManagementServiceArn: SigningKeyString =
      zio.aws.route53.model.primitives
        .SigningKeyString(impl.keyManagementServiceArn())
    override val name: SigningKeyName =
      zio.aws.route53.model.primitives.SigningKeyName(impl.name())
    override val status: SigningKeyStatus =
      zio.aws.route53.model.primitives.SigningKeyStatus(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest
  ): zio.aws.route53.model.CreateKeySigningKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
