package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{CloudWatchLogsLogGroupArn, ResourceId}
import scala.jdk.CollectionConverters._
final case class CreateQueryLoggingConfigRequest(
    hostedZoneId: ResourceId,
    cloudWatchLogsLogGroupArn: CloudWatchLogsLogGroupArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest = {
    import CreateQueryLoggingConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .cloudWatchLogsLogGroupArn(
        CloudWatchLogsLogGroupArn.unwrap(
          cloudWatchLogsLogGroupArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateQueryLoggingConfigRequest.ReadOnly =
    zio.aws.route53.model.CreateQueryLoggingConfigRequest.wrap(buildAwsValue())
}
object CreateQueryLoggingConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateQueryLoggingConfigRequest =
      zio.aws.route53.model.CreateQueryLoggingConfigRequest(
        hostedZoneId,
        cloudWatchLogsLogGroupArn
      )
    def hostedZoneId: ResourceId
    def cloudWatchLogsLogGroupArn: CloudWatchLogsLogGroupArn
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getCloudWatchLogsLogGroupArn
        : ZIO[Any, Nothing, CloudWatchLogsLogGroupArn] =
      ZIO.succeed(cloudWatchLogsLogGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest
  ) extends zio.aws.route53.model.CreateQueryLoggingConfigRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val cloudWatchLogsLogGroupArn: CloudWatchLogsLogGroupArn =
      zio.aws.route53.model.primitives
        .CloudWatchLogsLogGroupArn(impl.cloudWatchLogsLogGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest
  ): zio.aws.route53.model.CreateQueryLoggingConfigRequest.ReadOnly =
    new Wrapper(impl)
}
