package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters._
final case class CreateQueryLoggingConfigResponse(
    queryLoggingConfig: zio.aws.route53.model.QueryLoggingConfig,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse = {
    import CreateQueryLoggingConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse
      .builder()
      .queryLoggingConfig(queryLoggingConfig.buildAwsValue())
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly =
    zio.aws.route53.model.CreateQueryLoggingConfigResponse.wrap(buildAwsValue())
}
object CreateQueryLoggingConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateQueryLoggingConfigResponse =
      zio.aws.route53.model.CreateQueryLoggingConfigResponse(
        queryLoggingConfig.asEditable,
        location
      )
    def queryLoggingConfig: zio.aws.route53.model.QueryLoggingConfig.ReadOnly
    def location: ResourceURI
    def getQueryLoggingConfig
        : ZIO[Any, Nothing, zio.aws.route53.model.QueryLoggingConfig.ReadOnly] =
      ZIO.succeed(queryLoggingConfig)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse
  ) extends zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly {
    override val queryLoggingConfig
        : zio.aws.route53.model.QueryLoggingConfig.ReadOnly =
      zio.aws.route53.model.QueryLoggingConfig.wrap(impl.queryLoggingConfig())
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse
  ): zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly =
    new Wrapper(impl)
}
