package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters._
final case class CreateReusableDelegationSetResponse(
    delegationSet: zio.aws.route53.model.DelegationSet,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse = {
    import CreateReusableDelegationSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse
      .builder()
      .delegationSet(delegationSet.buildAwsValue())
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly =
    zio.aws.route53.model.CreateReusableDelegationSetResponse
      .wrap(buildAwsValue())
}
object CreateReusableDelegationSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateReusableDelegationSetResponse =
      zio.aws.route53.model
        .CreateReusableDelegationSetResponse(delegationSet.asEditable, location)
    def delegationSet: zio.aws.route53.model.DelegationSet.ReadOnly
    def location: ResourceURI
    def getDelegationSet
        : ZIO[Any, Nothing, zio.aws.route53.model.DelegationSet.ReadOnly] =
      ZIO.succeed(delegationSet)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse
  ) extends zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly {
    override val delegationSet: zio.aws.route53.model.DelegationSet.ReadOnly =
      zio.aws.route53.model.DelegationSet.wrap(impl.delegationSet())
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse
  ): zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly =
    new Wrapper(impl)
}
