package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  DNSName,
  TTL,
  TrafficPolicyId,
  TrafficPolicyVersion,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class CreateTrafficPolicyInstanceRequest(
    hostedZoneId: ResourceId,
    name: DNSName,
    ttl: TTL,
    trafficPolicyId: TrafficPolicyId,
    trafficPolicyVersion: TrafficPolicyVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest = {
    import CreateTrafficPolicyInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .name(DNSName.unwrap(name): java.lang.String)
      .ttl(TTL.unwrap(ttl): java.lang.Long)
      .trafficPolicyId(
        TrafficPolicyId.unwrap(trafficPolicyId): java.lang.String
      )
      .trafficPolicyVersion(
        TrafficPolicyVersion.unwrap(trafficPolicyVersion): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateTrafficPolicyInstanceRequest.ReadOnly =
    zio.aws.route53.model.CreateTrafficPolicyInstanceRequest
      .wrap(buildAwsValue())
}
object CreateTrafficPolicyInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateTrafficPolicyInstanceRequest =
      zio.aws.route53.model.CreateTrafficPolicyInstanceRequest(
        hostedZoneId,
        name,
        ttl,
        trafficPolicyId,
        trafficPolicyVersion
      )
    def hostedZoneId: ResourceId
    def name: DNSName
    def ttl: TTL
    def trafficPolicyId: TrafficPolicyId
    def trafficPolicyVersion: TrafficPolicyVersion
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(name)
    def getTtl: ZIO[Any, Nothing, TTL] = ZIO.succeed(ttl)
    def getTrafficPolicyId: ZIO[Any, Nothing, TrafficPolicyId] =
      ZIO.succeed(trafficPolicyId)
    def getTrafficPolicyVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(trafficPolicyVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest
  ) extends zio.aws.route53.model.CreateTrafficPolicyInstanceRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val name: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.name())
    override val ttl: TTL = zio.aws.route53.model.primitives.TTL(impl.ttl())
    override val trafficPolicyId: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.trafficPolicyId())
    override val trafficPolicyVersion: TrafficPolicyVersion =
      zio.aws.route53.model.primitives
        .TrafficPolicyVersion(impl.trafficPolicyVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest
  ): zio.aws.route53.model.CreateTrafficPolicyInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
