package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters._
final case class CreateTrafficPolicyResponse(
    trafficPolicy: zio.aws.route53.model.TrafficPolicy,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse = {
    import CreateTrafficPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse
      .builder()
      .trafficPolicy(trafficPolicy.buildAwsValue())
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly =
    zio.aws.route53.model.CreateTrafficPolicyResponse.wrap(buildAwsValue())
}
object CreateTrafficPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateTrafficPolicyResponse =
      zio.aws.route53.model
        .CreateTrafficPolicyResponse(trafficPolicy.asEditable, location)
    def trafficPolicy: zio.aws.route53.model.TrafficPolicy.ReadOnly
    def location: ResourceURI
    def getTrafficPolicy
        : ZIO[Any, Nothing, zio.aws.route53.model.TrafficPolicy.ReadOnly] =
      ZIO.succeed(trafficPolicy)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse
  ) extends zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly {
    override val trafficPolicy: zio.aws.route53.model.TrafficPolicy.ReadOnly =
      zio.aws.route53.model.TrafficPolicy.wrap(impl.trafficPolicy())
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse
  ): zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
