package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters._
final case class CreateTrafficPolicyVersionResponse(
    trafficPolicy: zio.aws.route53.model.TrafficPolicy,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse = {
    import CreateTrafficPolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse
      .builder()
      .trafficPolicy(trafficPolicy.buildAwsValue())
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly =
    zio.aws.route53.model.CreateTrafficPolicyVersionResponse
      .wrap(buildAwsValue())
}
object CreateTrafficPolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateTrafficPolicyVersionResponse =
      zio.aws.route53.model
        .CreateTrafficPolicyVersionResponse(trafficPolicy.asEditable, location)
    def trafficPolicy: zio.aws.route53.model.TrafficPolicy.ReadOnly
    def location: ResourceURI
    def getTrafficPolicy
        : ZIO[Any, Nothing, zio.aws.route53.model.TrafficPolicy.ReadOnly] =
      ZIO.succeed(trafficPolicy)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse
  ) extends zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly {
    override val trafficPolicy: zio.aws.route53.model.TrafficPolicy.ReadOnly =
      zio.aws.route53.model.TrafficPolicy.wrap(impl.trafficPolicy())
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse
  ): zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly =
    new Wrapper(impl)
}
