package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  SigningKeyStatusMessage,
  ServeSignature
}
import scala.jdk.CollectionConverters._
final case class DNSSECStatus(
    serveSignature: Optional[ServeSignature] = Optional.Absent,
    statusMessage: Optional[SigningKeyStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DNSSECStatus = {
    import DNSSECStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DNSSECStatus
      .builder()
      .optionallyWith(
        serveSignature.map(value =>
          ServeSignature.unwrap(value): java.lang.String
        )
      )(_.serveSignature)
      .optionallyWith(
        statusMessage.map(value =>
          SigningKeyStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.DNSSECStatus.ReadOnly =
    zio.aws.route53.model.DNSSECStatus.wrap(buildAwsValue())
}
object DNSSECStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DNSSECStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DNSSECStatus =
      zio.aws.route53.model.DNSSECStatus(
        serveSignature.map(value => value),
        statusMessage.map(value => value)
      )
    def serveSignature: Optional[ServeSignature]
    def statusMessage: Optional[SigningKeyStatusMessage]
    def getServeSignature: ZIO[Any, AwsError, ServeSignature] =
      AwsError.unwrapOptionField("serveSignature", serveSignature)
    def getStatusMessage: ZIO[Any, AwsError, SigningKeyStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DNSSECStatus
  ) extends zio.aws.route53.model.DNSSECStatus.ReadOnly {
    override val serveSignature: Optional[ServeSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serveSignature())
        .map(value => zio.aws.route53.model.primitives.ServeSignature(value))
    override val statusMessage: Optional[SigningKeyStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.route53.model.primitives.SigningKeyStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DNSSECStatus
  ): zio.aws.route53.model.DNSSECStatus.ReadOnly = new Wrapper(impl)
}
