package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class DeleteCidrCollectionRequest(id: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest = {
    import DeleteCidrCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest
      .builder()
      .id(UUID.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.DeleteCidrCollectionRequest.ReadOnly =
    zio.aws.route53.model.DeleteCidrCollectionRequest.wrap(buildAwsValue())
}
object DeleteCidrCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteCidrCollectionRequest =
      zio.aws.route53.model.DeleteCidrCollectionRequest(id)
    def id: UUID
    def getId: ZIO[Any, Nothing, UUID] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest
  ) extends zio.aws.route53.model.DeleteCidrCollectionRequest.ReadOnly {
    override val id: UUID = zio.aws.route53.model.primitives.UUID(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteCidrCollectionRequest
  ): zio.aws.route53.model.DeleteCidrCollectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
