package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.HealthCheckId
import scala.jdk.CollectionConverters._
final case class DeleteHealthCheckRequest(healthCheckId: HealthCheckId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest = {
    import DeleteHealthCheckRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest
      .builder()
      .healthCheckId(HealthCheckId.unwrap(healthCheckId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.DeleteHealthCheckRequest.ReadOnly =
    zio.aws.route53.model.DeleteHealthCheckRequest.wrap(buildAwsValue())
}
object DeleteHealthCheckRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteHealthCheckRequest =
      zio.aws.route53.model.DeleteHealthCheckRequest(healthCheckId)
    def healthCheckId: HealthCheckId
    def getHealthCheckId: ZIO[Any, Nothing, HealthCheckId] =
      ZIO.succeed(healthCheckId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest
  ) extends zio.aws.route53.model.DeleteHealthCheckRequest.ReadOnly {
    override val healthCheckId: HealthCheckId =
      zio.aws.route53.model.primitives.HealthCheckId(impl.healthCheckId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest
  ): zio.aws.route53.model.DeleteHealthCheckRequest.ReadOnly = new Wrapper(impl)
}
