package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class DeleteHostedZoneRequest(id: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest = {
    import DeleteHostedZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.DeleteHostedZoneRequest.ReadOnly =
    zio.aws.route53.model.DeleteHostedZoneRequest.wrap(buildAwsValue())
}
object DeleteHostedZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteHostedZoneRequest =
      zio.aws.route53.model.DeleteHostedZoneRequest(id)
    def id: ResourceId
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest
  ) extends zio.aws.route53.model.DeleteHostedZoneRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest
  ): zio.aws.route53.model.DeleteHostedZoneRequest.ReadOnly = new Wrapper(impl)
}
