package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.QueryLoggingConfigId
import scala.jdk.CollectionConverters._
final case class DeleteQueryLoggingConfigRequest(id: QueryLoggingConfigId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest = {
    import DeleteQueryLoggingConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest
      .builder()
      .id(QueryLoggingConfigId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.DeleteQueryLoggingConfigRequest.ReadOnly =
    zio.aws.route53.model.DeleteQueryLoggingConfigRequest.wrap(buildAwsValue())
}
object DeleteQueryLoggingConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteQueryLoggingConfigRequest =
      zio.aws.route53.model.DeleteQueryLoggingConfigRequest(id)
    def id: QueryLoggingConfigId
    def getId: ZIO[Any, Nothing, QueryLoggingConfigId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest
  ) extends zio.aws.route53.model.DeleteQueryLoggingConfigRequest.ReadOnly {
    override val id: QueryLoggingConfigId =
      zio.aws.route53.model.primitives.QueryLoggingConfigId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest
  ): zio.aws.route53.model.DeleteQueryLoggingConfigRequest.ReadOnly =
    new Wrapper(impl)
}
