package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.TrafficPolicyInstanceId
import scala.jdk.CollectionConverters._
final case class DeleteTrafficPolicyInstanceRequest(
    id: TrafficPolicyInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest = {
    import DeleteTrafficPolicyInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest
      .builder()
      .id(TrafficPolicyInstanceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.DeleteTrafficPolicyInstanceRequest.ReadOnly =
    zio.aws.route53.model.DeleteTrafficPolicyInstanceRequest
      .wrap(buildAwsValue())
}
object DeleteTrafficPolicyInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DeleteTrafficPolicyInstanceRequest =
      zio.aws.route53.model.DeleteTrafficPolicyInstanceRequest(id)
    def id: TrafficPolicyInstanceId
    def getId: ZIO[Any, Nothing, TrafficPolicyInstanceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest
  ) extends zio.aws.route53.model.DeleteTrafficPolicyInstanceRequest.ReadOnly {
    override val id: TrafficPolicyInstanceId =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest
  ): zio.aws.route53.model.DeleteTrafficPolicyInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
