package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.DimensionField
import scala.jdk.CollectionConverters._
final case class Dimension(name: DimensionField, value: DimensionField) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.Dimension = {
    import Dimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.Dimension
      .builder()
      .name(DimensionField.unwrap(name): java.lang.String)
      .value(DimensionField.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.Dimension.ReadOnly =
    zio.aws.route53.model.Dimension.wrap(buildAwsValue())
}
object Dimension {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.route53.model.Dimension] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.Dimension =
      zio.aws.route53.model.Dimension(name, value)
    def name: DimensionField
    def value: DimensionField
    def getName: ZIO[Any, Nothing, DimensionField] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, DimensionField] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.Dimension
  ) extends zio.aws.route53.model.Dimension.ReadOnly {
    override val name: DimensionField =
      zio.aws.route53.model.primitives.DimensionField(impl.name())
    override val value: DimensionField =
      zio.aws.route53.model.primitives.DimensionField(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.Dimension
  ): zio.aws.route53.model.Dimension.ReadOnly = new Wrapper(impl)
}
