package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class DisableHostedZoneDnssecRequest(hostedZoneId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest = {
    import DisableHostedZoneDnssecRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.DisableHostedZoneDnssecRequest.ReadOnly =
    zio.aws.route53.model.DisableHostedZoneDnssecRequest.wrap(buildAwsValue())
}
object DisableHostedZoneDnssecRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.DisableHostedZoneDnssecRequest =
      zio.aws.route53.model.DisableHostedZoneDnssecRequest(hostedZoneId)
    def hostedZoneId: ResourceId
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest
  ) extends zio.aws.route53.model.DisableHostedZoneDnssecRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest
  ): zio.aws.route53.model.DisableHostedZoneDnssecRequest.ReadOnly =
    new Wrapper(impl)
}
