package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class EnableHostedZoneDnssecRequest(hostedZoneId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest = {
    import EnableHostedZoneDnssecRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.EnableHostedZoneDnssecRequest.ReadOnly =
    zio.aws.route53.model.EnableHostedZoneDnssecRequest.wrap(buildAwsValue())
}
object EnableHostedZoneDnssecRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.EnableHostedZoneDnssecRequest =
      zio.aws.route53.model.EnableHostedZoneDnssecRequest(hostedZoneId)
    def hostedZoneId: ResourceId
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest
  ) extends zio.aws.route53.model.EnableHostedZoneDnssecRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest
  ): zio.aws.route53.model.EnableHostedZoneDnssecRequest.ReadOnly = new Wrapper(
    impl
  )
}
