package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  GeoLocationSubdivisionCode,
  GeoLocationCountryCode,
  GeoLocationContinentCode
}
import scala.jdk.CollectionConverters._
final case class GeoLocation(
    continentCode: Optional[GeoLocationContinentCode] = Optional.Absent,
    countryCode: Optional[GeoLocationCountryCode] = Optional.Absent,
    subdivisionCode: Optional[GeoLocationSubdivisionCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GeoLocation = {
    import GeoLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GeoLocation
      .builder()
      .optionallyWith(
        continentCode.map(value =>
          GeoLocationContinentCode.unwrap(value): java.lang.String
        )
      )(_.continentCode)
      .optionallyWith(
        countryCode.map(value =>
          GeoLocationCountryCode.unwrap(value): java.lang.String
        )
      )(_.countryCode)
      .optionallyWith(
        subdivisionCode.map(value =>
          GeoLocationSubdivisionCode.unwrap(value): java.lang.String
        )
      )(_.subdivisionCode)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GeoLocation.ReadOnly =
    zio.aws.route53.model.GeoLocation.wrap(buildAwsValue())
}
object GeoLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GeoLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GeoLocation =
      zio.aws.route53.model.GeoLocation(
        continentCode.map(value => value),
        countryCode.map(value => value),
        subdivisionCode.map(value => value)
      )
    def continentCode: Optional[GeoLocationContinentCode]
    def countryCode: Optional[GeoLocationCountryCode]
    def subdivisionCode: Optional[GeoLocationSubdivisionCode]
    def getContinentCode: ZIO[Any, AwsError, GeoLocationContinentCode] =
      AwsError.unwrapOptionField("continentCode", continentCode)
    def getCountryCode: ZIO[Any, AwsError, GeoLocationCountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getSubdivisionCode: ZIO[Any, AwsError, GeoLocationSubdivisionCode] =
      AwsError.unwrapOptionField("subdivisionCode", subdivisionCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GeoLocation
  ) extends zio.aws.route53.model.GeoLocation.ReadOnly {
    override val continentCode: Optional[GeoLocationContinentCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continentCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationContinentCode(value)
        )
    override val countryCode: Optional[GeoLocationCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countryCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationCountryCode(value)
        )
    override val subdivisionCode: Optional[GeoLocationSubdivisionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdivisionCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationSubdivisionCode(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GeoLocation
  ): zio.aws.route53.model.GeoLocation.ReadOnly = new Wrapper(impl)
}
