package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  GeoLocationSubdivisionName,
  GeoLocationCountryCode,
  GeoLocationContinentName,
  GeoLocationContinentCode,
  GeoLocationSubdivisionCode,
  GeoLocationCountryName
}
import scala.jdk.CollectionConverters._
final case class GeoLocationDetails(
    continentCode: Optional[GeoLocationContinentCode] = Optional.Absent,
    continentName: Optional[GeoLocationContinentName] = Optional.Absent,
    countryCode: Optional[GeoLocationCountryCode] = Optional.Absent,
    countryName: Optional[GeoLocationCountryName] = Optional.Absent,
    subdivisionCode: Optional[GeoLocationSubdivisionCode] = Optional.Absent,
    subdivisionName: Optional[GeoLocationSubdivisionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GeoLocationDetails = {
    import GeoLocationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GeoLocationDetails
      .builder()
      .optionallyWith(
        continentCode.map(value =>
          GeoLocationContinentCode.unwrap(value): java.lang.String
        )
      )(_.continentCode)
      .optionallyWith(
        continentName.map(value =>
          GeoLocationContinentName.unwrap(value): java.lang.String
        )
      )(_.continentName)
      .optionallyWith(
        countryCode.map(value =>
          GeoLocationCountryCode.unwrap(value): java.lang.String
        )
      )(_.countryCode)
      .optionallyWith(
        countryName.map(value =>
          GeoLocationCountryName.unwrap(value): java.lang.String
        )
      )(_.countryName)
      .optionallyWith(
        subdivisionCode.map(value =>
          GeoLocationSubdivisionCode.unwrap(value): java.lang.String
        )
      )(_.subdivisionCode)
      .optionallyWith(
        subdivisionName.map(value =>
          GeoLocationSubdivisionName.unwrap(value): java.lang.String
        )
      )(_.subdivisionName)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GeoLocationDetails.ReadOnly =
    zio.aws.route53.model.GeoLocationDetails.wrap(buildAwsValue())
}
object GeoLocationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GeoLocationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GeoLocationDetails =
      zio.aws.route53.model.GeoLocationDetails(
        continentCode.map(value => value),
        continentName.map(value => value),
        countryCode.map(value => value),
        countryName.map(value => value),
        subdivisionCode.map(value => value),
        subdivisionName.map(value => value)
      )
    def continentCode: Optional[GeoLocationContinentCode]
    def continentName: Optional[GeoLocationContinentName]
    def countryCode: Optional[GeoLocationCountryCode]
    def countryName: Optional[GeoLocationCountryName]
    def subdivisionCode: Optional[GeoLocationSubdivisionCode]
    def subdivisionName: Optional[GeoLocationSubdivisionName]
    def getContinentCode: ZIO[Any, AwsError, GeoLocationContinentCode] =
      AwsError.unwrapOptionField("continentCode", continentCode)
    def getContinentName: ZIO[Any, AwsError, GeoLocationContinentName] =
      AwsError.unwrapOptionField("continentName", continentName)
    def getCountryCode: ZIO[Any, AwsError, GeoLocationCountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getCountryName: ZIO[Any, AwsError, GeoLocationCountryName] =
      AwsError.unwrapOptionField("countryName", countryName)
    def getSubdivisionCode: ZIO[Any, AwsError, GeoLocationSubdivisionCode] =
      AwsError.unwrapOptionField("subdivisionCode", subdivisionCode)
    def getSubdivisionName: ZIO[Any, AwsError, GeoLocationSubdivisionName] =
      AwsError.unwrapOptionField("subdivisionName", subdivisionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GeoLocationDetails
  ) extends zio.aws.route53.model.GeoLocationDetails.ReadOnly {
    override val continentCode: Optional[GeoLocationContinentCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continentCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationContinentCode(value)
        )
    override val continentName: Optional[GeoLocationContinentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continentName())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationContinentName(value)
        )
    override val countryCode: Optional[GeoLocationCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countryCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationCountryCode(value)
        )
    override val countryName: Optional[GeoLocationCountryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.countryName())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationCountryName(value)
        )
    override val subdivisionCode: Optional[GeoLocationSubdivisionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdivisionCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationSubdivisionCode(value)
        )
    override val subdivisionName: Optional[GeoLocationSubdivisionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdivisionName())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationSubdivisionName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GeoLocationDetails
  ): zio.aws.route53.model.GeoLocationDetails.ReadOnly = new Wrapper(impl)
}
