package zio.aws.route53.model
import zio.aws.route53.model.primitives.{Bias, LocalZoneGroup, AWSRegion}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GeoProximityLocation(
    awsRegion: Optional[AWSRegion] = Optional.Absent,
    localZoneGroup: Optional[LocalZoneGroup] = Optional.Absent,
    coordinates: Optional[zio.aws.route53.model.Coordinates] = Optional.Absent,
    bias: Optional[Bias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GeoProximityLocation = {
    import GeoProximityLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GeoProximityLocation
      .builder()
      .optionallyWith(
        awsRegion.map(value => AWSRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .optionallyWith(
        localZoneGroup.map(value =>
          LocalZoneGroup.unwrap(value): java.lang.String
        )
      )(_.localZoneGroup)
      .optionallyWith(coordinates.map(value => value.buildAwsValue()))(
        _.coordinates
      )
      .optionallyWith(bias.map(value => Bias.unwrap(value): Integer))(_.bias)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GeoProximityLocation.ReadOnly =
    zio.aws.route53.model.GeoProximityLocation.wrap(buildAwsValue())
}
object GeoProximityLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GeoProximityLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GeoProximityLocation =
      zio.aws.route53.model.GeoProximityLocation(
        awsRegion.map(value => value),
        localZoneGroup.map(value => value),
        coordinates.map(value => value.asEditable),
        bias.map(value => value)
      )
    def awsRegion: Optional[AWSRegion]
    def localZoneGroup: Optional[LocalZoneGroup]
    def coordinates: Optional[zio.aws.route53.model.Coordinates.ReadOnly]
    def bias: Optional[Bias]
    def getAwsRegion: ZIO[Any, AwsError, AWSRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getLocalZoneGroup: ZIO[Any, AwsError, LocalZoneGroup] =
      AwsError.unwrapOptionField("localZoneGroup", localZoneGroup)
    def getCoordinates
        : ZIO[Any, AwsError, zio.aws.route53.model.Coordinates.ReadOnly] =
      AwsError.unwrapOptionField("coordinates", coordinates)
    def getBias: ZIO[Any, AwsError, Bias] =
      AwsError.unwrapOptionField("bias", bias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GeoProximityLocation
  ) extends zio.aws.route53.model.GeoProximityLocation.ReadOnly {
    override val awsRegion: Optional[AWSRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.route53.model.primitives.AWSRegion(value))
    override val localZoneGroup: Optional[LocalZoneGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localZoneGroup())
        .map(value => zio.aws.route53.model.primitives.LocalZoneGroup(value))
    override val coordinates
        : Optional[zio.aws.route53.model.Coordinates.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coordinates())
        .map(value => zio.aws.route53.model.Coordinates.wrap(value))
    override val bias: Optional[Bias] = zio.aws.core.internal
      .optionalFromNullable(impl.bias())
      .map(value => zio.aws.route53.model.primitives.Bias(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GeoProximityLocation
  ): zio.aws.route53.model.GeoProximityLocation.ReadOnly = new Wrapper(impl)
}
