package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ChangeId
import scala.jdk.CollectionConverters._
final case class GetChangeRequest(id: ChangeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetChangeRequest = {
    import GetChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetChangeRequest
      .builder()
      .id(ChangeId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetChangeRequest.ReadOnly =
    zio.aws.route53.model.GetChangeRequest.wrap(buildAwsValue())
}
object GetChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetChangeRequest =
      zio.aws.route53.model.GetChangeRequest(id)
    def id: ChangeId
    def getId: ZIO[Any, Nothing, ChangeId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetChangeRequest
  ) extends zio.aws.route53.model.GetChangeRequest.ReadOnly {
    override val id: ChangeId =
      zio.aws.route53.model.primitives.ChangeId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetChangeRequest
  ): zio.aws.route53.model.GetChangeRequest.ReadOnly = new Wrapper(impl)
}
