package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGeoLocationResponse(
    geoLocationDetails: zio.aws.route53.model.GeoLocationDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetGeoLocationResponse = {
    import GetGeoLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetGeoLocationResponse
      .builder()
      .geoLocationDetails(geoLocationDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetGeoLocationResponse.ReadOnly =
    zio.aws.route53.model.GetGeoLocationResponse.wrap(buildAwsValue())
}
object GetGeoLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetGeoLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetGeoLocationResponse =
      zio.aws.route53.model
        .GetGeoLocationResponse(geoLocationDetails.asEditable)
    def geoLocationDetails: zio.aws.route53.model.GeoLocationDetails.ReadOnly
    def getGeoLocationDetails
        : ZIO[Any, Nothing, zio.aws.route53.model.GeoLocationDetails.ReadOnly] =
      ZIO.succeed(geoLocationDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetGeoLocationResponse
  ) extends zio.aws.route53.model.GetGeoLocationResponse.ReadOnly {
    override val geoLocationDetails
        : zio.aws.route53.model.GeoLocationDetails.ReadOnly =
      zio.aws.route53.model.GeoLocationDetails.wrap(impl.geoLocationDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetGeoLocationResponse
  ): zio.aws.route53.model.GetGeoLocationResponse.ReadOnly = new Wrapper(impl)
}
