package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.HealthCheckCount
import scala.jdk.CollectionConverters._
final case class GetHealthCheckCountResponse(
    healthCheckCount: HealthCheckCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse = {
    import GetHealthCheckCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse
      .builder()
      .healthCheckCount(
        HealthCheckCount.unwrap(healthCheckCount): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly =
    zio.aws.route53.model.GetHealthCheckCountResponse.wrap(buildAwsValue())
}
object GetHealthCheckCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHealthCheckCountResponse =
      zio.aws.route53.model.GetHealthCheckCountResponse(healthCheckCount)
    def healthCheckCount: HealthCheckCount
    def getHealthCheckCount: ZIO[Any, Nothing, HealthCheckCount] =
      ZIO.succeed(healthCheckCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse
  ) extends zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly {
    override val healthCheckCount: HealthCheckCount =
      zio.aws.route53.model.primitives.HealthCheckCount(impl.healthCheckCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse
  ): zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly = new Wrapper(
    impl
  )
}
