package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetHealthCheckLastFailureReasonResponse(
    healthCheckObservations: Iterable[
      zio.aws.route53.model.HealthCheckObservation
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse = {
    import GetHealthCheckLastFailureReasonResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse
      .builder()
      .healthCheckObservations(healthCheckObservations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly =
    zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse
      .wrap(buildAwsValue())
}
object GetHealthCheckLastFailureReasonResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse =
      zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse(
        healthCheckObservations.map { item =>
          item.asEditable
        }
      )
    def healthCheckObservations
        : List[zio.aws.route53.model.HealthCheckObservation.ReadOnly]
    def getHealthCheckObservations: ZIO[Any, Nothing, List[
      zio.aws.route53.model.HealthCheckObservation.ReadOnly
    ]] = ZIO.succeed(healthCheckObservations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse
  ) extends zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly {
    override val healthCheckObservations
        : List[zio.aws.route53.model.HealthCheckObservation.ReadOnly] = impl
      .healthCheckObservations()
      .asScala
      .map { item =>
        zio.aws.route53.model.HealthCheckObservation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse
  ): zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly =
    new Wrapper(impl)
}
