package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.HealthCheckId
import scala.jdk.CollectionConverters._
final case class GetHealthCheckRequest(healthCheckId: HealthCheckId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHealthCheckRequest = {
    import GetHealthCheckRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHealthCheckRequest
      .builder()
      .healthCheckId(HealthCheckId.unwrap(healthCheckId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHealthCheckRequest.ReadOnly =
    zio.aws.route53.model.GetHealthCheckRequest.wrap(buildAwsValue())
}
object GetHealthCheckRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHealthCheckRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHealthCheckRequest =
      zio.aws.route53.model.GetHealthCheckRequest(healthCheckId)
    def healthCheckId: HealthCheckId
    def getHealthCheckId: ZIO[Any, Nothing, HealthCheckId] =
      ZIO.succeed(healthCheckId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckRequest
  ) extends zio.aws.route53.model.GetHealthCheckRequest.ReadOnly {
    override val healthCheckId: HealthCheckId =
      zio.aws.route53.model.primitives.HealthCheckId(impl.healthCheckId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckRequest
  ): zio.aws.route53.model.GetHealthCheckRequest.ReadOnly = new Wrapper(impl)
}
