package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetHealthCheckResponse(
    healthCheck: zio.aws.route53.model.HealthCheck
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHealthCheckResponse = {
    import GetHealthCheckResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHealthCheckResponse
      .builder()
      .healthCheck(healthCheck.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHealthCheckResponse.ReadOnly =
    zio.aws.route53.model.GetHealthCheckResponse.wrap(buildAwsValue())
}
object GetHealthCheckResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHealthCheckResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHealthCheckResponse =
      zio.aws.route53.model.GetHealthCheckResponse(healthCheck.asEditable)
    def healthCheck: zio.aws.route53.model.HealthCheck.ReadOnly
    def getHealthCheck
        : ZIO[Any, Nothing, zio.aws.route53.model.HealthCheck.ReadOnly] =
      ZIO.succeed(healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckResponse
  ) extends zio.aws.route53.model.GetHealthCheckResponse.ReadOnly {
    override val healthCheck: zio.aws.route53.model.HealthCheck.ReadOnly =
      zio.aws.route53.model.HealthCheck.wrap(impl.healthCheck())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckResponse
  ): zio.aws.route53.model.GetHealthCheckResponse.ReadOnly = new Wrapper(impl)
}
