package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.HealthCheckId
import scala.jdk.CollectionConverters._
final case class GetHealthCheckStatusRequest(healthCheckId: HealthCheckId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest = {
    import GetHealthCheckStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest
      .builder()
      .healthCheckId(HealthCheckId.unwrap(healthCheckId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHealthCheckStatusRequest.ReadOnly =
    zio.aws.route53.model.GetHealthCheckStatusRequest.wrap(buildAwsValue())
}
object GetHealthCheckStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHealthCheckStatusRequest =
      zio.aws.route53.model.GetHealthCheckStatusRequest(healthCheckId)
    def healthCheckId: HealthCheckId
    def getHealthCheckId: ZIO[Any, Nothing, HealthCheckId] =
      ZIO.succeed(healthCheckId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest
  ) extends zio.aws.route53.model.GetHealthCheckStatusRequest.ReadOnly {
    override val healthCheckId: HealthCheckId =
      zio.aws.route53.model.primitives.HealthCheckId(impl.healthCheckId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest
  ): zio.aws.route53.model.GetHealthCheckStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
