package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.HostedZoneCount
import scala.jdk.CollectionConverters._
final case class GetHostedZoneCountResponse(hostedZoneCount: HostedZoneCount) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse = {
    import GetHostedZoneCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse
      .builder()
      .hostedZoneCount(HostedZoneCount.unwrap(hostedZoneCount): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly =
    zio.aws.route53.model.GetHostedZoneCountResponse.wrap(buildAwsValue())
}
object GetHostedZoneCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHostedZoneCountResponse =
      zio.aws.route53.model.GetHostedZoneCountResponse(hostedZoneCount)
    def hostedZoneCount: HostedZoneCount
    def getHostedZoneCount: ZIO[Any, Nothing, HostedZoneCount] =
      ZIO.succeed(hostedZoneCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse
  ) extends zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly {
    override val hostedZoneCount: HostedZoneCount =
      zio.aws.route53.model.primitives.HostedZoneCount(impl.hostedZoneCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse
  ): zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly = new Wrapper(
    impl
  )
}
