package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetHostedZoneLimitRequest(
    `type`: zio.aws.route53.model.HostedZoneLimitType,
    hostedZoneId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest = {
    import GetHostedZoneLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest
      .builder()
      .`type`(`type`.unwrap)
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHostedZoneLimitRequest.ReadOnly =
    zio.aws.route53.model.GetHostedZoneLimitRequest.wrap(buildAwsValue())
}
object GetHostedZoneLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHostedZoneLimitRequest =
      zio.aws.route53.model.GetHostedZoneLimitRequest(`type`, hostedZoneId)
    def `type`: zio.aws.route53.model.HostedZoneLimitType
    def hostedZoneId: ResourceId
    def getType: ZIO[Any, Nothing, zio.aws.route53.model.HostedZoneLimitType] =
      ZIO.succeed(`type`)
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest
  ) extends zio.aws.route53.model.GetHostedZoneLimitRequest.ReadOnly {
    override val `type`: zio.aws.route53.model.HostedZoneLimitType =
      zio.aws.route53.model.HostedZoneLimitType.wrap(impl.`type`())
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest
  ): zio.aws.route53.model.GetHostedZoneLimitRequest.ReadOnly = new Wrapper(
    impl
  )
}
