package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.UsageCount
import scala.jdk.CollectionConverters._
final case class GetHostedZoneLimitResponse(
    limit: zio.aws.route53.model.HostedZoneLimit,
    count: UsageCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse = {
    import GetHostedZoneLimitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse
      .builder()
      .limit(limit.buildAwsValue())
      .count(UsageCount.unwrap(count): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly =
    zio.aws.route53.model.GetHostedZoneLimitResponse.wrap(buildAwsValue())
}
object GetHostedZoneLimitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHostedZoneLimitResponse =
      zio.aws.route53.model.GetHostedZoneLimitResponse(limit.asEditable, count)
    def limit: zio.aws.route53.model.HostedZoneLimit.ReadOnly
    def count: UsageCount
    def getLimit
        : ZIO[Any, Nothing, zio.aws.route53.model.HostedZoneLimit.ReadOnly] =
      ZIO.succeed(limit)
    def getCount: ZIO[Any, Nothing, UsageCount] = ZIO.succeed(count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse
  ) extends zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly {
    override val limit: zio.aws.route53.model.HostedZoneLimit.ReadOnly =
      zio.aws.route53.model.HostedZoneLimit.wrap(impl.limit())
    override val count: UsageCount =
      zio.aws.route53.model.primitives.UsageCount(impl.count())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse
  ): zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly = new Wrapper(
    impl
  )
}
