package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetHostedZoneRequest(id: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHostedZoneRequest = {
    import GetHostedZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHostedZoneRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHostedZoneRequest.ReadOnly =
    zio.aws.route53.model.GetHostedZoneRequest.wrap(buildAwsValue())
}
object GetHostedZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHostedZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHostedZoneRequest =
      zio.aws.route53.model.GetHostedZoneRequest(id)
    def id: ResourceId
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneRequest
  ) extends zio.aws.route53.model.GetHostedZoneRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneRequest
  ): zio.aws.route53.model.GetHostedZoneRequest.ReadOnly = new Wrapper(impl)
}
