package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetHostedZoneResponse(
    hostedZone: zio.aws.route53.model.HostedZone,
    delegationSet: Optional[zio.aws.route53.model.DelegationSet] =
      Optional.Absent,
    vpCs: Optional[Iterable[zio.aws.route53.model.VPC]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetHostedZoneResponse = {
    import GetHostedZoneResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetHostedZoneResponse
      .builder()
      .hostedZone(hostedZone.buildAwsValue())
      .optionallyWith(delegationSet.map(value => value.buildAwsValue()))(
        _.delegationSet
      )
      .optionallyWith(
        vpCs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpCs)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.GetHostedZoneResponse.ReadOnly =
    zio.aws.route53.model.GetHostedZoneResponse.wrap(buildAwsValue())
}
object GetHostedZoneResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetHostedZoneResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.GetHostedZoneResponse =
      zio.aws.route53.model.GetHostedZoneResponse(
        hostedZone.asEditable,
        delegationSet.map(value => value.asEditable),
        vpCs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hostedZone: zio.aws.route53.model.HostedZone.ReadOnly
    def delegationSet: Optional[zio.aws.route53.model.DelegationSet.ReadOnly]
    def vpCs: Optional[List[zio.aws.route53.model.VPC.ReadOnly]]
    def getHostedZone
        : ZIO[Any, Nothing, zio.aws.route53.model.HostedZone.ReadOnly] =
      ZIO.succeed(hostedZone)
    def getDelegationSet
        : ZIO[Any, AwsError, zio.aws.route53.model.DelegationSet.ReadOnly] =
      AwsError.unwrapOptionField("delegationSet", delegationSet)
    def getVpCs: ZIO[Any, AwsError, List[zio.aws.route53.model.VPC.ReadOnly]] =
      AwsError.unwrapOptionField("vpCs", vpCs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneResponse
  ) extends zio.aws.route53.model.GetHostedZoneResponse.ReadOnly {
    override val hostedZone: zio.aws.route53.model.HostedZone.ReadOnly =
      zio.aws.route53.model.HostedZone.wrap(impl.hostedZone())
    override val delegationSet
        : Optional[zio.aws.route53.model.DelegationSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delegationSet())
        .map(value => zio.aws.route53.model.DelegationSet.wrap(value))
    override val vpCs: Optional[List[zio.aws.route53.model.VPC.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpCs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.VPC.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetHostedZoneResponse
  ): zio.aws.route53.model.GetHostedZoneResponse.ReadOnly = new Wrapper(impl)
}
