package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.TrafficPolicyInstanceCount
import scala.jdk.CollectionConverters._
final case class GetTrafficPolicyInstanceCountResponse(
    trafficPolicyInstanceCount: TrafficPolicyInstanceCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse = {
    import GetTrafficPolicyInstanceCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse
      .builder()
      .trafficPolicyInstanceCount(
        TrafficPolicyInstanceCount.unwrap(trafficPolicyInstanceCount): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly =
    zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse
      .wrap(buildAwsValue())
}
object GetTrafficPolicyInstanceCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse =
      zio.aws.route53.model
        .GetTrafficPolicyInstanceCountResponse(trafficPolicyInstanceCount)
    def trafficPolicyInstanceCount: TrafficPolicyInstanceCount
    def getTrafficPolicyInstanceCount
        : ZIO[Any, Nothing, TrafficPolicyInstanceCount] =
      ZIO.succeed(trafficPolicyInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse
  ) extends zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly {
    override val trafficPolicyInstanceCount: TrafficPolicyInstanceCount =
      zio.aws.route53.model.primitives
        .TrafficPolicyInstanceCount(impl.trafficPolicyInstanceCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse
  ): zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly =
    new Wrapper(impl)
}
