package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  HealthCheckVersion,
  HealthCheckNonce,
  HealthCheckId
}
import scala.jdk.CollectionConverters._
final case class HealthCheck(
    id: HealthCheckId,
    callerReference: HealthCheckNonce,
    linkedService: Optional[zio.aws.route53.model.LinkedService] =
      Optional.Absent,
    healthCheckConfig: zio.aws.route53.model.HealthCheckConfig,
    healthCheckVersion: HealthCheckVersion,
    cloudWatchAlarmConfiguration: Optional[
      zio.aws.route53.model.CloudWatchAlarmConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.HealthCheck = {
    import HealthCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.HealthCheck
      .builder()
      .id(HealthCheckId.unwrap(id): java.lang.String)
      .callerReference(
        HealthCheckNonce.unwrap(callerReference): java.lang.String
      )
      .optionallyWith(linkedService.map(value => value.buildAwsValue()))(
        _.linkedService
      )
      .healthCheckConfig(healthCheckConfig.buildAwsValue())
      .healthCheckVersion(
        HealthCheckVersion.unwrap(healthCheckVersion): java.lang.Long
      )
      .optionallyWith(
        cloudWatchAlarmConfiguration.map(value => value.buildAwsValue())
      )(_.cloudWatchAlarmConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.HealthCheck.ReadOnly =
    zio.aws.route53.model.HealthCheck.wrap(buildAwsValue())
}
object HealthCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.HealthCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.HealthCheck =
      zio.aws.route53.model.HealthCheck(
        id,
        callerReference,
        linkedService.map(value => value.asEditable),
        healthCheckConfig.asEditable,
        healthCheckVersion,
        cloudWatchAlarmConfiguration.map(value => value.asEditable)
      )
    def id: HealthCheckId
    def callerReference: HealthCheckNonce
    def linkedService: Optional[zio.aws.route53.model.LinkedService.ReadOnly]
    def healthCheckConfig: zio.aws.route53.model.HealthCheckConfig.ReadOnly
    def healthCheckVersion: HealthCheckVersion
    def cloudWatchAlarmConfiguration
        : Optional[zio.aws.route53.model.CloudWatchAlarmConfiguration.ReadOnly]
    def getId: ZIO[Any, Nothing, HealthCheckId] = ZIO.succeed(id)
    def getCallerReference: ZIO[Any, Nothing, HealthCheckNonce] =
      ZIO.succeed(callerReference)
    def getLinkedService
        : ZIO[Any, AwsError, zio.aws.route53.model.LinkedService.ReadOnly] =
      AwsError.unwrapOptionField("linkedService", linkedService)
    def getHealthCheckConfig
        : ZIO[Any, Nothing, zio.aws.route53.model.HealthCheckConfig.ReadOnly] =
      ZIO.succeed(healthCheckConfig)
    def getHealthCheckVersion: ZIO[Any, Nothing, HealthCheckVersion] =
      ZIO.succeed(healthCheckVersion)
    def getCloudWatchAlarmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.route53.model.CloudWatchAlarmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchAlarmConfiguration",
      cloudWatchAlarmConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.HealthCheck
  ) extends zio.aws.route53.model.HealthCheck.ReadOnly {
    override val id: HealthCheckId =
      zio.aws.route53.model.primitives.HealthCheckId(impl.id())
    override val callerReference: HealthCheckNonce =
      zio.aws.route53.model.primitives.HealthCheckNonce(impl.callerReference())
    override val linkedService
        : Optional[zio.aws.route53.model.LinkedService.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.linkedService())
        .map(value => zio.aws.route53.model.LinkedService.wrap(value))
    override val healthCheckConfig
        : zio.aws.route53.model.HealthCheckConfig.ReadOnly =
      zio.aws.route53.model.HealthCheckConfig.wrap(impl.healthCheckConfig())
    override val healthCheckVersion: HealthCheckVersion =
      zio.aws.route53.model.primitives
        .HealthCheckVersion(impl.healthCheckVersion())
    override val cloudWatchAlarmConfiguration: Optional[
      zio.aws.route53.model.CloudWatchAlarmConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchAlarmConfiguration())
      .map(value =>
        zio.aws.route53.model.CloudWatchAlarmConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.HealthCheck
  ): zio.aws.route53.model.HealthCheck.ReadOnly = new Wrapper(impl)
}
