package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait HealthCheckRegion {
  def unwrap: software.amazon.awssdk.services.route53.model.HealthCheckRegion
}
object HealthCheckRegion {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.HealthCheckRegion
  ): zio.aws.route53.model.HealthCheckRegion = value match {
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.US_EAST_1 =>
      val r = `us-east-1`
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.US_WEST_1 =>
      val r = `us-west-1`
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.US_WEST_2 =>
      val r = `us-west-2`
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.AP_SOUTHEAST_1 =>
      val r = `ap-southeast-1`
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckRegion.SA_EAST_1 =>
      val r = `sa-east-1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object `us-east-1` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.US_EAST_1
  }
  case object `us-west-1` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.US_WEST_1
  }
  case object `us-west-2` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.US_WEST_2
  }
  case object `eu-west-1` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.EU_WEST_1
  }
  case object `ap-southeast-1` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.AP_SOUTHEAST_1
  }
  case object `ap-southeast-2` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.AP_SOUTHEAST_2
  }
  case object `ap-northeast-1` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.AP_NORTHEAST_1
  }
  case object `sa-east-1` extends zio.aws.route53.model.HealthCheckRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckRegion =
      software.amazon.awssdk.services.route53.model.HealthCheckRegion.SA_EAST_1
  }
}
