package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait HealthCheckType {
  def unwrap: software.amazon.awssdk.services.route53.model.HealthCheckType
}
object HealthCheckType {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.HealthCheckType
  ): zio.aws.route53.model.HealthCheckType = value match {
    case software.amazon.awssdk.services.route53.model.HealthCheckType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.HTTPS =>
      val r = HTTPS
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.HTTP_STR_MATCH =>
      val r = HTTP_STR_MATCH
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.HTTPS_STR_MATCH =>
      val r = HTTPS_STR_MATCH
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.CALCULATED =>
      val r = CALCULATED
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.CLOUDWATCH_METRIC =>
      val r = CLOUDWATCH_METRIC
      r
    case software.amazon.awssdk.services.route53.model.HealthCheckType.RECOVERY_CONTROL =>
      val r = RECOVERY_CONTROL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.HTTP
  }
  case object HTTPS extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.HTTPS
  }
  case object HTTP_STR_MATCH extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.HTTP_STR_MATCH
  }
  case object HTTPS_STR_MATCH extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.HTTPS_STR_MATCH
  }
  case object TCP extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.TCP
  }
  case object CALCULATED extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.CALCULATED
  }
  case object CLOUDWATCH_METRIC extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.CLOUDWATCH_METRIC
  }
  case object RECOVERY_CONTROL extends zio.aws.route53.model.HealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HealthCheckType =
      software.amazon.awssdk.services.route53.model.HealthCheckType.RECOVERY_CONTROL
  }
}
