package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{IsPrivateZone, ResourceDescription}
import scala.jdk.CollectionConverters._
final case class HostedZoneConfig(
    comment: Optional[ResourceDescription] = Optional.Absent,
    privateZone: Optional[IsPrivateZone] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.HostedZoneConfig = {
    import HostedZoneConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.HostedZoneConfig
      .builder()
      .optionallyWith(
        comment.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.comment)
      .optionallyWith(
        privateZone.map(value => IsPrivateZone.unwrap(value): java.lang.Boolean)
      )(_.privateZone)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.HostedZoneConfig.ReadOnly =
    zio.aws.route53.model.HostedZoneConfig.wrap(buildAwsValue())
}
object HostedZoneConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.HostedZoneConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.HostedZoneConfig =
      zio.aws.route53.model.HostedZoneConfig(
        comment.map(value => value),
        privateZone.map(value => value)
      )
    def comment: Optional[ResourceDescription]
    def privateZone: Optional[IsPrivateZone]
    def getComment: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("comment", comment)
    def getPrivateZone: ZIO[Any, AwsError, IsPrivateZone] =
      AwsError.unwrapOptionField("privateZone", privateZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneConfig
  ) extends zio.aws.route53.model.HostedZoneConfig.ReadOnly {
    override val comment: Optional[ResourceDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.route53.model.primitives.ResourceDescription(value))
    override val privateZone: Optional[IsPrivateZone] = zio.aws.core.internal
      .optionalFromNullable(impl.privateZone())
      .map(value => zio.aws.route53.model.primitives.IsPrivateZone(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneConfig
  ): zio.aws.route53.model.HostedZoneConfig.ReadOnly = new Wrapper(impl)
}
