package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.LimitValue
import scala.jdk.CollectionConverters._
final case class HostedZoneLimit(
    `type`: zio.aws.route53.model.HostedZoneLimitType,
    value: LimitValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.HostedZoneLimit = {
    import HostedZoneLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.HostedZoneLimit
      .builder()
      .`type`(`type`.unwrap)
      .value(LimitValue.unwrap(value): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.HostedZoneLimit.ReadOnly =
    zio.aws.route53.model.HostedZoneLimit.wrap(buildAwsValue())
}
object HostedZoneLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.HostedZoneLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.HostedZoneLimit =
      zio.aws.route53.model.HostedZoneLimit(`type`, value)
    def `type`: zio.aws.route53.model.HostedZoneLimitType
    def value: LimitValue
    def getType: ZIO[Any, Nothing, zio.aws.route53.model.HostedZoneLimitType] =
      ZIO.succeed(`type`)
    def getValue: ZIO[Any, Nothing, LimitValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneLimit
  ) extends zio.aws.route53.model.HostedZoneLimit.ReadOnly {
    override val `type`: zio.aws.route53.model.HostedZoneLimitType =
      zio.aws.route53.model.HostedZoneLimitType.wrap(impl.`type`())
    override val value: LimitValue =
      zio.aws.route53.model.primitives.LimitValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneLimit
  ): zio.aws.route53.model.HostedZoneLimit.ReadOnly = new Wrapper(impl)
}
